<?php 
$user = auth()->user();
$todaysDate = date('d M Y');
$planValidity = showDateTime($user->validity, 'd M Y');
?>



<head>
    
    <link rel="stylesheet" href="https://unpkg.com/flickity@2.0.11/dist/flickity.min.css">
<script src="https://unpkg.com/flickity@2.0.11/dist/flickity.pkgd.min.js"></script>
<style>

        body{
            overflow: hidden;
        }

    
        
        .carousel-wrapper .carousel .carousel-cell{
            
            padding: 15px;
            width: 14%;
            height: auto;
            min-width: 120px;
            margin: 0 40px;
            transition: transform 500ms ease;
           
        }
        .carousel-wrapper .carousel .carousel-cell .more{
            display: block;
            opacity: 0;
            margin: 5px 0 15px 0;
            text-align: center;
            font-size: 10px;
            color: #cfcfcf;
            text-decoration: none;
            transition: opacity 300ms ease;
        }
        .carousel-wrapper .carousel .carousel-cell .more:hover,
        .carousel-wrapper .carousel .carousel-cell .more:active,
        .carousel-wrapper .carousel .carousel-cell .more:visited,
        .carousel-wrapper .carousel .carousel-cell .more:focus{
            color: #cfcfcf;
            text-decoration: none;
        }
        .carousel-wrapper .carousel .carousel-cell .line{
        }
        .carousel-wrapper .carousel .carousel-cell .price{
            color:red;
            position: absolute;
            font-weight: 700;
            margin:;
            left: 50%;
            transform: translate(-50%);
            opacity: 0;
            transition: opacity 300ms ease 300ms;
        }
        .carousel-wrapper .carousel .carousel-cell .price sup{
            top: 2px;
            position: absolute;
        }
        .carousel-wrapper .carousel .carousel-cell.is-selected{
            transform: scale(1.2);
        }
        .carousel-wrapper .carousel .carousel-cell.is-selected .line{
            height: 35px;
        }
        .carousel-wrapper .carousel .carousel-cell.is-selected .price,
        .carousel-wrapper .carousel .carousel-cell.is-selected .more{
            opacity: 1;
        }
        .carousel-wrapper .flickity-page-dots{
            display: none;
        }
        .carousel-wrapper .flickity-viewport,
        .carousel-wrapper .flickity-slider{
            overflow: visible;
        }
        @media  {
            .carousel-wrapper .carousel .carousel-cell{
                width: 85%;
                height: auto;
                padding: 5px;
            }
            
        }




</style>


</head> 

    
    <body>
    
    <div class="container pt-5 pb-3 mt-5 mb-2 bg-primary">
        <div class="row">

            <div class="col-7 pt-1 ps-2">


                <h2 class="text-light"> Membership Plan</h2>
                <h6 class="text-light">Join with us.</h6>
                
                <h6 class="text-light">Current Plan : <b style="font-size: 16px;" class="text-warning"> 
                            <?php if($user->plan_id != 0): ?>
                                <?php echo e(__(@$user->plan->name)); ?>

                            <?php else: ?>
                                <?php echo app('translator')->get('No Plan'); ?>
                            <?php endif; ?>
                    </b>
                </h6>
                <h6 class="text-light">Validity : <b style="font-size: 13px;" class="text-light"> 
                                <?php if($user->plan_id != 0): ?>
                                <?php echo e($planValidity); ?>

                                <?php else: ?>
                                    <?php echo app('translator')->get('N/A'); ?>
                                <?php endif; ?>
                    </b>
                </h6>

            </div>

            <div align="center" class="col-5"><img width="100px" src="https://i.ibb.co/cgpDbXm/vip-2.png" /></div>

        </div>

    </div>
    
    
    
    <div class="container mt-5">
        <div class="carousel-wrapper">
            <div class="carousel" data-flickity>

                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <div class="carousel-cell">
                <!-- card block -->
                <div class="card-block bg-primary mt-2">
                    <div class="card-main">

                        <div class="card-button dropdown mt-2 me-1">
                            <button type="button" class="btn btn-link btn-icon" data-bs-toggle="dropdown">
                                        <?php if(auth()->check()): ?>
                                        <?php if(auth()->user()->plan_id == $plan->id): ?>
                                            <button class="btn btn-outline-light" disabled><?php echo app('translator')->get('Current'); ?></button>
                                        <?php else: ?>
                                            <button data-toggle="modal" data-target="#BuyModal" class="buyBtn btn btn-light" data-id="<?php echo e($plan->id); ?>"><?php echo app('translator')->get('Buy'); ?></button>
                                        <?php endif; ?>
                                        <?php else: ?>
                                            <button data-toggle="modal" data-target="#BuyModal" class="buyBtn btn btn-light" data-id="<?php echo e($plan->id); ?>"><?php echo app('translator')->get('Buy'); ?></button>
                                        <?php endif; ?>
                            </button>
                            
                        </div>

                                <div class="balance">
                                    <span class="label">Plan Name</span>
                                    <h1 class="title"><?php echo e(__($plan->name)); ?></h1>
                                </div>
                        
                        <div class="in">

                                <div class="card-number">
                                    <span class="label">Price</span>
                                    <?php echo e(__(showAmount($plan->price))); ?> <?php echo e($general->cur_text); ?>

                                </div>


                            <div class="bottom">

                                <div class="card-expiry">
                                    <span class="label">Expiry</span>
                                    <?php echo e($plan->validity); ?> Days
                                </div>

                                <div class="card-ccv">
                                    <span class="label">Daily Limit</span>
                                    <?php echo e($plan->daily_limit); ?> Ads
                                </div>
                                    
                            </div>
                        </div>
                    </div>
                </div>
                <!-- * card block -->
                <div class="line"></div>
            </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        

            </div>
        </div>
    </div>

  
    
    
    <section style="height: 110px;">

    </section>
    
    
                
                <div class="modal fade" id="BuyModal" tabindex="-1" role="dialog" aria-labelledby="BuyModal" aria-hidden="true">
                    <div class="modal-dialog">
            
                        <!-- Modal content-->
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title"><?php echo app('translator')->get('Confirmation'); ?></h4>
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                            </div>
                            <form action="<?php echo e(route('user.buyPlan')); ?>" method="POST">
                                <div class="modal-body text-center">
            
                                    <?php echo e(csrf_field()); ?>

                                    <div class="form-group m-0">
                                        <input type="hidden" name="id">
                                    </div>
                                    <strong><?php echo app('translator')->get('Are you sure to subscribe this plan ?'); ?></strong>
            
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                                    <button type="submit" class="btn btn-success"><?php echo app('translator')->get('Confirm'); ?></button>
                                </div>
            
                            </form>
                        </div>
            
                    </div>
                </div>
    
   
    
    
    
    
    

</body>
<?php $__env->startPush('script'); ?>
<script type="text/javascript">
    (function ($) {
        "use strict";
    	$('.buyBtn').click(function(){
    		var modal = $('#BuyModal');
    		modal.find('input[name=id]').val($(this).data('id'));
    		
    	});
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate .'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smeranto/public_html/core/resources/views/templates/basic/user/plans.blade.php ENDPATH**/ ?>