@extends($activeTemplate .'layouts.master')
@section('content')
@include($activeTemplate.'breadcrumb')

<!-- App Header -->
<div class="appHeader no-border transparent position-absolute">
        <div class="left">
            <a href="#" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle"></div>
        <div class="right">
            <a href="{{ route('user.register') }}" class="headerButton">
                Register
            </a>
        </div>
    </div>
    <!-- * App Header -->

@php
    $authImage = getContent('auth_image.content', true);
@endphp

<div id="appCapsule">
<section class="registration-section pt-100 pb-100">
   <div class="container">
        <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="registration-wrapper section--bg">
            <form class="transparent-form" method="POST" action="{{ route('user.password.email') }}">
                @csrf
                <div class="row">
                    <div class="col-12 form-group">
                        <label class="label">Select One <sup class="text--danger">*</sup></label>
                        <select class="form-control mb-2 mt-1" name="type">
                            <option value="email">@lang('E-Mail')</option>
                            <option value="username">@lang('Username')</option>
                        </select>
                    </div>
                    </div>
                    <div class="col-12 form-group">
                        <label class="my_value label"></label>
                        <input type="text" class="form-control mt-1 @error('value') is-invalid @enderror" name="value" value="{{ old('value') }}" required autofocus="off">
                        <div class="custom-icon-field">
                        @error('value')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <div class="col-lg-12 form-group mt-4">
                        <button type="submit" class="btn btn-primary btn--base w-100">@lang('Send Password Code')</button>
                    </div>
                </div>
            </form>
            </div>
        </div>
        </div>
    </div>
</section>
</div>
@endsection
@push('script')
<script>

    (function($){
        "use strict";

        myVal();
        $('select[name=type]').on('change',function(){
            myVal();
        });
        function myVal(){
            $('.my_value').text($('select[name=type] :selected').text());
        }
    })(jQuery)
</script>
@endpush