<?php

namespace App\Http\Controllers\Gateway\TZSMMPAY;

use App\Models\Deposit;
use App\Http\Controllers\Gateway\PaymentController;
use App\Http\Controllers\Controller;
use App\Lib\CurlRequest;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request; 

class ProcessController extends Controller
{

    public static function process($deposit)
    {
        $credentials = json_decode($deposit->gatewayCurrency()->gateway_parameter);
        $apiKey = $credentials->api_key;
        $url = 'https://tzsmmpay.com/api/payment/create';
    
        // Build the query string for GET request
        $paymentData = [
            'api_key' => $apiKey,
            'cus_name' => $deposit->user->firstname . ' ' . $deposit->user->lastname,
            'cus_email' => 'demo@gmail.com',
            'cus_number' => Session::get('Track'),
            'amount' => $deposit->amount,
            'currency' => $deposit->method_currency,
            'success_url' => route(gatewayRedirectUrl(true)),
            'cancel_url' => route(gatewayRedirectUrl()),
            'callback_url' => route('ipn.' . $deposit->gateway->alias),
        ];
    
        // Append query parameters to the URL
        $url .= '?' . http_build_query($paymentData);
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/x-www-form-urlencoded'
        ]);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_FAILONERROR, true);
        curl_setopt($ch, CURLOPT_VERBOSE, true);
    
        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);
    
        if ($error) {
            return json_encode(['error' => 'TRUE', 'message' => $error]);
        }
    
        $responseData = json_decode($response, true);
    
        if ($responseData === null) {
            return json_encode(['error' => 'TRUE', 'message' => 'Invalid JSON response or empty response received.']);
        }
    
        if (isset($responseData['success']) && $responseData['success']) {
            return json_encode([
                'redirect' => 'TRUE',
                'redirect_url' => $responseData['payment_url']
            ]);
        } else {
            return json_encode([
                'error' => 'TRUE',
                'message' => $responseData['messages'] ?? 'An error occurred.'
            ]);
        }
    }



    public function ipn(Request $request)
    {
    
        try {
            // Validate the request inputs
            $validator = \Validator::make($request->all(), [
                'amount' => 'required|numeric',
                'cus_name' => 'required',
                'cus_email' => 'required|email',
                'cus_number' => 'required',
                'method_transaction_id' => 'required',
                'status' => 'required',
                'extra' => 'nullable|array',
            ]);
    
            // Return validation errors if any
            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'messages' => implode(', ', $validator->errors()->all()),
                ]);
            }
    
            // Retrieve the track number from the request
            $track = $request->cus_number;
    
            // Check if a deposit exists for the provided track number
            $deposit = Deposit::where('trx', $track)->orderBy('id', 'DESC')->first();
            if (!$deposit) {
                return response()->json([
                    'success' => false,
                    'messages' => 'Deposit not found for track number: ' . $track,
                ]);
            }
    
            // Check the payment status
            if ($request->status === 'Completed') {
                $deposit->detail = $request->all();
                $deposit->save();
                // Update user data for the successful payment
                PaymentController::userDataUpdate($deposit->trx);
                return response()->json([
                    'success' => true,
                    'messages' => 'Deposit successful.',
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'messages' => 'Payment status not completed.',
                ]);
            }
        } catch (\Exception $e) {
            // Handle any unexpected errors
            return response()->json([
                'success' => false,
                'messages' => 'An error occurred: ' . $e->getMessage(),
            ]);
        }
    }

}